/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementTraverser;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractTestElement
implements TestElement,
Serializable,
Searchable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Map<String, JMeterProperty> propMap = Collections.synchronizedMap(new LinkedHashMap());
    private transient Set<JMeterProperty> temporaryProperties;
    private transient boolean runningVersion = false;
    private transient JMeterContext threadContext = null;
    private transient String threadName = null;

    @Override
    public Object clone() {
        try {
            TestElement clonedElement = (TestElement)this.getClass().newInstance();
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                clonedElement.setProperty(iter.next().clone());
            }
            clonedElement.setRunningVersion(this.runningVersion);
            return clonedElement;
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void clear() {
        this.propMap.clear();
    }

    @Override
    public void clearTestElementChildren() {
    }

    @Override
    public void removeProperty(String key) {
        this.propMap.remove(key);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTestElement) {
            return ((Object)((AbstractTestElement)o).propMap).equals(this.propMap);
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void addTestElement(TestElement el) {
        this.mergeIn(el);
    }

    @Override
    public void setName(String name) {
        this.setProperty("TestElement.name", name);
    }

    @Override
    public String getName() {
        return this.getPropertyAsString("TestElement.name");
    }

    @Override
    public void setComment(String comment) {
        this.setProperty(new StringProperty("TestPlan.comments", comment));
    }

    @Override
    public String getComment() {
        return this.getProperty("TestPlan.comments").getStringValue();
    }

    @Override
    public JMeterProperty getProperty(String key) {
        JMeterProperty prop = this.propMap.get(key);
        if (prop == null) {
            prop = new NullProperty(key);
        }
        return prop;
    }

    @Override
    public void traverse(TestElementTraverser traverser) {
        PropertyIterator iter = this.propertyIterator();
        traverser.startTestElement(this);
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
        traverser.endTestElement(this);
    }

    protected void traverseProperty(TestElementTraverser traverser, JMeterProperty value) {
        traverser.startProperty(value);
        if (value instanceof TestElementProperty) {
            ((TestElement)value.getObjectValue()).traverse(traverser);
        } else if (value instanceof CollectionProperty) {
            this.traverseCollection((CollectionProperty)value, traverser);
        } else if (value instanceof MapProperty) {
            this.traverseMap((MapProperty)value, traverser);
        }
        traverser.endProperty(value);
    }

    protected void traverseMap(MapProperty map, TestElementTraverser traverser) {
        PropertyIterator iter = map.valueIterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    protected void traverseCollection(CollectionProperty col, TestElementTraverser traverser) {
        PropertyIterator iter = col.iterator();
        while (iter.hasNext()) {
            this.traverseProperty(traverser, iter.next());
        }
    }

    @Override
    public int getPropertyAsInt(String key) {
        return this.getProperty(key).getIntValue();
    }

    @Override
    public int getPropertyAsInt(String key, int defaultValue) {
        JMeterProperty jmp = this.getProperty(key);
        return jmp instanceof NullProperty ? defaultValue : jmp.getIntValue();
    }

    @Override
    public boolean getPropertyAsBoolean(String key) {
        return this.getProperty(key).getBooleanValue();
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultVal) {
        JMeterProperty jmp = this.getProperty(key);
        return jmp instanceof NullProperty ? defaultVal : jmp.getBooleanValue();
    }

    @Override
    public float getPropertyAsFloat(String key) {
        return this.getProperty(key).getFloatValue();
    }

    @Override
    public long getPropertyAsLong(String key) {
        return this.getProperty(key).getLongValue();
    }

    @Override
    public long getPropertyAsLong(String key, long defaultValue) {
        JMeterProperty jmp = this.getProperty(key);
        return jmp instanceof NullProperty ? defaultValue : jmp.getLongValue();
    }

    @Override
    public double getPropertyAsDouble(String key) {
        return this.getProperty(key).getDoubleValue();
    }

    @Override
    public String getPropertyAsString(String key) {
        return this.getProperty(key).getStringValue();
    }

    @Override
    public String getPropertyAsString(String key, String defaultValue) {
        JMeterProperty jmp = this.getProperty(key);
        return jmp instanceof NullProperty ? defaultValue : jmp.getStringValue();
    }

    protected void addProperty(JMeterProperty property, boolean clone) {
        JMeterProperty propertyToPut = property;
        if (clone) {
            propertyToPut = property.clone();
        }
        if (this.isRunningVersion()) {
            this.setTemporary(propertyToPut);
        } else {
            this.clearTemporary(property);
        }
        JMeterProperty prop = this.getProperty(property.getName());
        if (prop instanceof NullProperty || prop instanceof StringProperty && prop.getStringValue().equals("")) {
            this.propMap.put(property.getName(), propertyToPut);
        } else {
            prop.mergeIn(propertyToPut);
        }
    }

    protected void addProperty(JMeterProperty property) {
        this.addProperty(property, false);
    }

    protected void clearTemporary(JMeterProperty property) {
        if (this.temporaryProperties != null) {
            this.temporaryProperties.remove(property);
        }
    }

    protected void logProperties() {
        if (log.isDebugEnabled()) {
            PropertyIterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                JMeterProperty prop = iter.next();
                log.debug("Property " + prop.getName() + " is temp? " + this.isTemporary(prop) + " and is a " + prop.getObjectValue());
            }
        }
    }

    @Override
    public void setProperty(JMeterProperty property) {
        if (this.isRunningVersion()) {
            if (this.getProperty(property.getName()) instanceof NullProperty) {
                this.addProperty(property);
            } else {
                this.getProperty(property.getName()).setObjectValue(property.getObjectValue());
            }
        } else {
            this.propMap.put(property.getName(), property);
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.setProperty(new StringProperty(name, value));
    }

    @Override
    public void setProperty(String name, String value, String dflt) {
        if (dflt.equals(value)) {
            this.removeProperty(name);
        } else {
            this.setProperty(new StringProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, boolean value) {
        this.setProperty(new BooleanProperty(name, value));
    }

    @Override
    public void setProperty(String name, boolean value, boolean dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new BooleanProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, int value) {
        this.setProperty(new IntegerProperty(name, value));
    }

    @Override
    public void setProperty(String name, int value, int dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new IntegerProperty(name, value));
        }
    }

    @Override
    public void setProperty(String name, long value) {
        this.setProperty(new LongProperty(name, value));
    }

    @Override
    public void setProperty(String name, long value, long dflt) {
        if (value == dflt) {
            this.removeProperty(name);
        } else {
            this.setProperty(new LongProperty(name, value));
        }
    }

    @Override
    public PropertyIterator propertyIterator() {
        return new PropertyIteratorImpl(this.propMap.values());
    }

    protected void mergeIn(TestElement element) {
        PropertyIterator iter = element.propertyIterator();
        while (iter.hasNext()) {
            JMeterProperty prop = iter.next();
            this.addProperty(prop, false);
        }
    }

    @Override
    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
        PropertyIterator iter = this.propertyIterator();
        while (iter.hasNext()) {
            iter.next().setRunningVersion(runningVersion);
        }
    }

    @Override
    public void recoverRunningVersion() {
        Iterator<Map.Entry<String, JMeterProperty>> iter = this.propMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, JMeterProperty> entry = iter.next();
            JMeterProperty prop = entry.getValue();
            if (this.isTemporary(prop)) {
                iter.remove();
                this.clearTemporary(prop);
                continue;
            }
            prop.recoverRunningVersion(this);
        }
        this.emptyTemporary();
    }

    protected void emptyTemporary() {
        if (this.temporaryProperties != null) {
            this.temporaryProperties.clear();
        }
    }

    @Override
    public boolean isTemporary(JMeterProperty property) {
        if (this.temporaryProperties == null) {
            return false;
        }
        return this.temporaryProperties.contains(property);
    }

    @Override
    public void setTemporary(JMeterProperty property) {
        if (this.temporaryProperties == null) {
            this.temporaryProperties = new LinkedHashSet<JMeterProperty>();
        }
        this.temporaryProperties.add(property);
        if (property instanceof MultiProperty) {
            PropertyIterator iter = ((MultiProperty)property).iterator();
            while (iter.hasNext()) {
                this.setTemporary(iter.next());
            }
        }
    }

    @Override
    public JMeterContext getThreadContext() {
        if (this.threadContext == null) {
            this.threadContext = JMeterContextService.getContext();
        }
        return this.threadContext;
    }

    @Override
    public void setThreadContext(JMeterContext inthreadContext) {
        if (this.threadContext != null && inthreadContext != this.threadContext) {
            throw new RuntimeException("Attempting to reset the thread context");
        }
        this.threadContext = inthreadContext;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public void setThreadName(String inthreadName) {
        if (this.threadName != null && !this.threadName.equals(inthreadName)) {
            throw new RuntimeException("Attempting to reset the thread name");
        }
        this.threadName = inthreadName;
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.getProperty("TestElement.enabled") instanceof NullProperty || this.getPropertyAsBoolean("TestElement.enabled");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty(new BooleanProperty("TestElement.enabled", enabled));
    }

    @Override
    public List<String> getSearchableTokens() throws Exception {
        ArrayList<String> result = new ArrayList<String>(25);
        PropertyIterator iterator = this.propertyIterator();
        while (iterator.hasNext()) {
            JMeterProperty jMeterProperty = iterator.next();
            result.add(jMeterProperty.getName());
            result.add(jMeterProperty.getStringValue());
        }
        return result;
    }

    protected final void addPropertiesValues(List<String> result, Set<String> propertyNames) {
        PropertyIterator iterator = this.propertyIterator();
        while (iterator.hasNext()) {
            JMeterProperty jMeterProperty = iterator.next();
            if (!propertyNames.contains(jMeterProperty.getName())) continue;
            result.add(jMeterProperty.getStringValue());
        }
    }
}

