/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;

public class TextAreaEditor
extends PropertyEditorSupport
implements FocusListener,
PropertyChangeListener {
    private final JSyntaxTextArea textUI = new JSyntaxTextArea(20, 20);
    private final JTextScrollPane scroller;

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }

    private final void init() {
        this.textUI.discardAllEdits();
        this.textUI.addFocusListener(this);
    }

    public TextAreaEditor() {
        this.scroller = new JTextScrollPane(this.textUI, true);
        this.init();
    }

    public TextAreaEditor(Object source) {
        super(source);
        this.scroller = new JTextScrollPane(this.textUI, true);
        this.init();
        this.setValue(source);
    }

    public TextAreaEditor(PropertyDescriptor descriptor) {
        this.textUI.setLanguage((String)descriptor.getValue("textLanguage"));
        this.scroller = new JTextScrollPane(this.textUI, true);
        this.init();
    }

    @Override
    public String getAsText() {
        return this.textUI.getText();
    }

    @Override
    public Component getCustomEditor() {
        return this.scroller;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.textUI.setInitialText(text);
        this.textUI.setCaretPosition(0);
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.textUI.setInitialText(value.toString());
            this.textUI.setCaretPosition(0);
        } else {
            this.textUI.setInitialText("");
        }
    }

    @Override
    public Object getValue() {
        return this.textUI.getText();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof ComboStringEditor) {
            ComboStringEditor cse = (ComboStringEditor)source;
            String lang = cse.getAsText().toLowerCase();
            this.textUI.setLanguage(lang);
        }
    }
}

