/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class ResultSaver
extends AbstractTestElement
implements Serializable,
SampleListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final Object LOCK = new Object();
    private static long sequenceNumber = 0L;
    private static String timeStamp;
    private static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmm_";
    private static int numberPadLength;
    public static final String FILENAME = "FileSaver.filename";
    public static final String VARIABLE_NAME = "FileSaver.variablename";
    public static final String ERRORS_ONLY = "FileSaver.errorsonly";
    public static final String SUCCESS_ONLY = "FileSaver.successonly";
    public static final String SKIP_AUTO_NUMBER = "FileSaver.skipautonumber";
    public static final String SKIP_SUFFIX = "FileSaver.skipsuffix";
    public static final String ADD_TIMESTAMP = "FileSaver.addTimstamp";
    public static final String NUMBER_PAD_LENGTH = "FileSaver.numberPadLen";

    private synchronized long nextNumber() {
        return ++sequenceNumber;
    }

    public ResultSaver() {
    }

    public ResultSaver(String name) {
        this();
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = LOCK;
        synchronized (object) {
            sequenceNumber = 0L;
            if (this.getAddTimeStamp()) {
                SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
                timeStamp = format.format(new Date());
            } else {
                timeStamp = "";
            }
            numberPadLength = this.getNumberPadLen();
        }
        super.clear();
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.processSample(e.getResult(), new Counter());
    }

    private void processSample(SampleResult s, Counter c) {
        this.saveSample(s, c.num++);
        SampleResult[] sr = s.getSubResults();
        for (int i = 0; i < sr.length; ++i) {
            this.processSample(sr[i], c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveSample(SampleResult s, int num) {
        if (s.isSuccessful() ? this.getErrorsOnly() : this.getSuccessOnly()) {
            return;
        }
        String fileName = this.makeFileName(s.getContentType(), this.getSkipAutoNumber(), this.getSkipSuffix());
        log.debug("Saving " + s.getSampleLabel() + " in " + fileName);
        s.setResultFileName(fileName);
        String variable = this.getVariableName();
        if (variable.length() > 0) {
            if (num > 0) {
                StringBuilder sb = new StringBuilder(variable);
                sb.append(num);
                variable = sb.toString();
            }
            JMeterContextService.getContext().getVariables().put(variable, fileName);
        }
        File out = new File(fileName);
        FileOutputStream pw = null;
        try {
            pw = new FileOutputStream(out);
            JOrphanUtils.write((byte[])s.getResponseData(), (OutputStream)pw);
        }
        catch (FileNotFoundException e1) {
            log.error("Error creating sample file for " + s.getSampleLabel(), (Throwable)e1);
            JOrphanUtils.closeQuietly((Closeable)pw);
        }
        catch (IOException e12) {
            log.error("Error saving sample " + s.getSampleLabel(), (Throwable)e12);
            {
                catch (Throwable throwable) {
                    JOrphanUtils.closeQuietly(pw);
                    throw throwable;
                }
            }
            JOrphanUtils.closeQuietly((Closeable)pw);
        }
        JOrphanUtils.closeQuietly((Closeable)pw);
    }

    private String makeFileName(String contentType, boolean skipAutoNumber, boolean skipSuffix) {
        StringBuilder sb = new StringBuilder(FileServer.resolveBaseRelativeName(this.getFilename()));
        sb.append(timeStamp);
        if (!skipAutoNumber) {
            String number = Long.toString(this.nextNumber());
            for (int i = number.length(); i < numberPadLength; ++i) {
                sb.append('0');
            }
            sb.append(number);
        }
        if (!skipSuffix) {
            sb.append('.');
            if (contentType != null) {
                int i = contentType.indexOf(47);
                if (i != -1) {
                    int j = contentType.indexOf(59);
                    if (j != -1) {
                        sb.append(contentType.substring(i + 1, j));
                    } else {
                        sb.append(contentType.substring(i + 1));
                    }
                } else {
                    sb.append("unknown");
                }
            } else {
                sb.append("unknown");
            }
        }
        return sb.toString();
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    private String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    private String getVariableName() {
        return this.getPropertyAsString(VARIABLE_NAME, "");
    }

    private boolean getErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY);
    }

    private boolean getSkipAutoNumber() {
        return this.getPropertyAsBoolean(SKIP_AUTO_NUMBER);
    }

    private boolean getSkipSuffix() {
        return this.getPropertyAsBoolean(SKIP_SUFFIX);
    }

    private boolean getSuccessOnly() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY);
    }

    private boolean getAddTimeStamp() {
        return this.getPropertyAsBoolean(ADD_TIMESTAMP);
    }

    private int getNumberPadLen() {
        return this.getPropertyAsInt(NUMBER_PAD_LENGTH, 0);
    }

    private static class Counter {
        int num;

        private Counter() {
        }
    }
}

