/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WhileController
extends GenericController
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private static final String CONDITION = "WhileController.condition";

    private boolean endOfLoop(boolean loopEnd) {
        boolean res;
        String cnd = this.getCondition().trim();
        if (log.isDebugEnabled()) {
            log.debug("Condition string:" + cnd + ".");
        }
        if (loopEnd && cnd.length() == 0 || "LAST".equalsIgnoreCase(cnd)) {
            JMeterVariables threadVars = JMeterContextService.getContext().getVariables();
            res = "false".equalsIgnoreCase(threadVars.get("JMeterThread.last_sample_ok"));
        } else {
            res = "false".equalsIgnoreCase(cnd);
        }
        if (log.isDebugEnabled()) {
            log.debug("Condition value: " + res);
        }
        return res;
    }

    @Override
    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop(true)) {
            return null;
        }
        return this.next();
    }

    @Override
    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.endOfLoop(true);
    }

    @Override
    public Sampler next() {
        if (this.isFirst() && this.endOfLoop(false)) {
            return null;
        }
        return super.next();
    }

    public void setCondition(String string) {
        if (log.isDebugEnabled()) {
            log.debug("setCondition(" + string + ")");
        }
        this.setProperty(new StringProperty(CONDITION, string));
    }

    public String getCondition() {
        JMeterProperty prop = this.getProperty(CONDITION);
        prop.recoverRunningVersion(this);
        return prop.getStringValue();
    }
}

