/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.ObjectTableModel;

public class RowDetailDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 6578889215615435475L;
    private static final String NEXT = "next";
    private static final String PREVIOUS = "previous";
    private static final String CLOSE = "close";
    private static final String UPDATE = "update";
    private JLabel nameLabel;
    private JTextField nameTF;
    private JLabel valueLabel;
    private JSyntaxTextArea valueTA;
    private JButton nextButton;
    private JButton previousButton;
    private JButton closeButton;
    private ObjectTableModel tableModel;
    private int selectedRow;
    private boolean textChanged = true;

    public RowDetailDialog() {
    }

    public RowDetailDialog(ObjectTableModel tableModel, int selectedRow) {
        super((Frame)null, JMeterUtils.getResString("detail"), true);
        this.tableModel = tableModel;
        this.selectedRow = selectedRow;
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -8699034338969407625L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -1529005452976176873L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RowDetailDialog.this.doUpdate(actionEvent);
                RowDetailDialog.this.setVisible(false);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.nameLabel = new JLabel(JMeterUtils.getResString("name"));
        this.nameTF = new JTextField(JMeterUtils.getResString("name"), 20);
        this.nameTF.getDocument().addDocumentListener(this);
        JPanel namePane = new JPanel(new BorderLayout());
        namePane.add((Component)this.nameLabel, "West");
        namePane.add((Component)this.nameTF, "Center");
        this.valueLabel = new JLabel(JMeterUtils.getResString("value"));
        this.valueTA = new JSyntaxTextArea(30, 80);
        this.valueTA.getDocument().addDocumentListener(this);
        this.setValues(this.selectedRow);
        JPanel valuePane = new JPanel(new BorderLayout());
        valuePane.add((Component)this.valueLabel, "North");
        JTextScrollPane jTextScrollPane = new JTextScrollPane(this.valueTA);
        valuePane.add((Component)((Object)jTextScrollPane), "Center");
        JPanel detailPanel = new JPanel(new BorderLayout());
        detailPanel.add((Component)namePane, "North");
        detailPanel.add((Component)valuePane, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        mainPanel.add((Component)detailPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton updateButton = new JButton(JMeterUtils.getResString(UPDATE));
        updateButton.setActionCommand(UPDATE);
        updateButton.addActionListener(this);
        this.closeButton = new JButton(JMeterUtils.getResString(CLOSE));
        this.closeButton.setActionCommand(CLOSE);
        this.closeButton.addActionListener(this);
        this.nextButton = new JButton(JMeterUtils.getResString(NEXT));
        this.nextButton.setActionCommand(NEXT);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
        this.previousButton = new JButton(JMeterUtils.getResString(PREVIOUS));
        this.previousButton.setActionCommand(PREVIOUS);
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(this.selectedRow > 0);
        buttonsPanel.add(updateButton);
        buttonsPanel.add(this.previousButton);
        buttonsPanel.add(this.nextButton);
        buttonsPanel.add(this.closeButton);
        mainPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add(mainPanel);
        this.nameTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CLOSE)) {
            this.setVisible(false);
        } else if (action.equals(NEXT)) {
            ++this.selectedRow;
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(this.selectedRow < this.tableModel.getRowCount() - 1);
            this.setValues(this.selectedRow);
        } else if (action.equals(PREVIOUS)) {
            --this.selectedRow;
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(this.selectedRow > 0);
            this.setValues(this.selectedRow);
        } else if (action.equals(UPDATE)) {
            this.doUpdate(e);
        }
    }

    private void setValues(int selectedRow) {
        this.nameTF.setText((String)this.tableModel.getValueAt(selectedRow, 0));
        this.valueTA.setInitialText((String)this.tableModel.getValueAt(selectedRow, 1));
        this.valueTA.setCaretPosition(0);
        this.textChanged = false;
    }

    protected void doUpdate(ActionEvent actionEvent) {
        this.tableModel.setValueAt((Object)this.nameTF.getText(), this.selectedRow, 0);
        this.tableModel.setValueAt((Object)this.valueTA.getText(), this.selectedRow, 1);
        this.closeButton.setText(JMeterUtils.getResString(CLOSE));
        this.textChanged = false;
    }

    private void changeLabelButton() {
        if (!this.textChanged) {
            this.closeButton.setText(JMeterUtils.getResString("cancel"));
            this.textChanged = true;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changeLabelButton();
    }
}

