/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Image;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class BufferedImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private Image bgImage;

    public BufferedImageBackgroundPainterStrategy(RTextAreaBase ta) {
        super(ta);
    }

    protected void paintImage(Graphics g, int x, int y) {
        if (this.bgImage != null) {
            g.drawImage(this.bgImage, x, y, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescaleImage(int width, int height, int hint) {
        Image master = this.getMasterImage();
        if (master != null) {
            this.bgImage = master.getScaledInstance(width, height, hint);
            this.tracker.addImage(this.bgImage, 1);
            try {
                this.tracker.waitForID(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.bgImage = null;
                return;
            }
            finally {
                this.tracker.removeImage(this.bgImage, 1);
            }
        } else {
            this.bgImage = null;
        }
    }
}

