/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class ReportMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JMenu fileMenu;
    private JMenuItem file_save_as;
    private JMenuItem file_load;
    private JMenuItem file_merge;
    private JMenuItem file_exit;
    private JMenuItem file_close;
    private JMenu editMenu;
    private JMenu edit_add;
    private JMenu runMenu;
    private JMenuItem run_start;
    private JMenu remote_start;
    private JMenuItem remote_start_all;
    private final Collection<JMenuItem> remote_engine_start = new LinkedList<JMenuItem>();
    private JMenuItem run_stop;
    private JMenuItem run_shut;
    private JMenu remote_stop;
    private JMenuItem remote_stop_all;
    private final Collection<JMenuItem> remote_engine_stop = new LinkedList<JMenuItem>();
    private JMenuItem run_clear;
    private JMenuItem run_clearAll;
    private JMenu optionsMenu;
    private JMenu lafMenu;
    private JMenuItem sslManager;
    private JMenu helpMenu;
    private JMenuItem help_about;
    private String[] remoteHosts;
    private JMenu remote_exit;
    private JMenuItem remote_exit_all;
    private final Collection<JMenuItem> remote_engine_exit = new LinkedList<JMenuItem>();
    public static final String ACTION_SHUTDOWN = "shutdown";
    public static final String ACTION_STOP = "stop";
    public static final String ACTION_START = "start";

    public ReportMenuBar() {
        this.remoteHosts = JOrphanUtils.split((String)JMeterUtils.getPropDefault((String)"remote_hosts", (String)""), (String)",");
        if (this.remoteHosts.length == 1 && this.remoteHosts[0].equals("")) {
            this.remoteHosts = new String[0];
        }
        this.getRemoteItems();
        this.createMenuBar();
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.file_save_as.setEnabled(enabled);
    }

    public void setFileLoadEnabled(boolean enabled) {
        if (this.file_load != null) {
            this.file_load.setEnabled(enabled);
        }
        if (this.file_merge != null) {
            this.file_merge.setEnabled(enabled);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.editMenu != null) {
            this.editMenu.setEnabled(enabled);
        }
    }

    public void setEditAddMenu(JMenu menu) {
        if (this.edit_add != null) {
            this.editMenu.remove(this.edit_add);
        }
        this.edit_add = menu;
        this.editMenu.insert(this.edit_add, 0);
    }

    public void setEditMenu(JPopupMenu menu) {
        if (menu != null) {
            this.editMenu.removeAll();
            Component[] comps = menu.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.editMenu.add(comps[i]);
            }
            this.editMenu.setEnabled(true);
        }
    }

    public void setEditAddEnabled(boolean enabled) {
        if (this.edit_add != null) {
            this.edit_add.setEnabled(enabled);
        }
        this.setEditEnabled(enabled);
    }

    public void setEditRemoveEnabled(boolean enabled) {
        if (enabled) {
            this.setEditEnabled(true);
        } else if (!this.edit_add.isEnabled()) {
            this.editMenu.setEnabled(false);
        }
    }

    public void createMenuBar() {
        this.makeFileMenu();
        this.makeEditMenu();
        this.makeRunMenu();
        this.makeOptionsMenu();
        this.makeHelpMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.runMenu);
        this.add(this.optionsMenu);
        this.add(this.helpMenu);
    }

    private void makeHelpMenu() {
        this.helpMenu = new JMenu(JMeterUtils.getResString((String)"help"));
        this.helpMenu.setMnemonic('H');
        JMenuItem contextHelp = new JMenuItem(JMeterUtils.getResString((String)"help"), 72);
        contextHelp.setActionCommand("help");
        contextHelp.setAccelerator(KeyStrokes.HELP);
        contextHelp.addActionListener(ReportActionRouter.getInstance());
        this.help_about = new JMenuItem(JMeterUtils.getResString((String)"about"), 65);
        this.help_about.setActionCommand("about");
        this.help_about.addActionListener(ReportActionRouter.getInstance());
        this.helpMenu.add(contextHelp);
        this.helpMenu.add(this.help_about);
    }

    private void makeOptionsMenu() {
        this.optionsMenu = new JMenu(JMeterUtils.getResString((String)"option"));
        JMenuItem functionHelper = new JMenuItem(JMeterUtils.getResString((String)"function_dialog_menu_item"), 70);
        functionHelper.addActionListener(ReportActionRouter.getInstance());
        functionHelper.setActionCommand("functions");
        functionHelper.setAccelerator(KeyStrokes.FUNCTIONS);
        this.lafMenu = new JMenu(JMeterUtils.getResString((String)"appearance"));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafs.length; ++i) {
            JMenuItem laf = new JMenuItem(lafs[i].getName());
            laf.addActionListener(ReportActionRouter.getInstance());
            laf.setActionCommand("laf:" + lafs[i].getClassName());
            this.lafMenu.setMnemonic('L');
            this.lafMenu.add(laf);
        }
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.add(functionHelper);
        this.optionsMenu.add(this.lafMenu);
        if (SSLManager.isSSLSupported()) {
            this.sslManager = new JMenuItem(JMeterUtils.getResString((String)"sslmanager"));
            this.sslManager.addActionListener(ReportActionRouter.getInstance());
            this.sslManager.setActionCommand("sslManager");
            this.sslManager.setMnemonic('S');
            this.sslManager.setAccelerator(KeyStrokes.SSL_MANAGER);
            this.optionsMenu.add(this.sslManager);
        }
        this.optionsMenu.add(this.makeLanguageMenu());
    }

    private JMenu makeLanguageMenu() {
        return JMeterMenuBar.makeLanguageMenu();
    }

    private void makeRunMenu() {
        this.runMenu = new JMenu(JMeterUtils.getResString((String)"run"));
        this.runMenu.setMnemonic('R');
        this.run_start = new JMenuItem(JMeterUtils.getResString((String)ACTION_START), 83);
        this.run_start.setAccelerator(KeyStrokes.ACTION_START);
        this.run_start.addActionListener(ReportActionRouter.getInstance());
        this.run_start.setActionCommand(ACTION_START);
        this.run_stop = new JMenuItem(JMeterUtils.getResString((String)ACTION_STOP), 84);
        this.run_stop.setAccelerator(KeyStrokes.ACTION_STOP);
        this.run_stop.setEnabled(false);
        this.run_stop.addActionListener(ReportActionRouter.getInstance());
        this.run_stop.setActionCommand(ACTION_STOP);
        this.run_shut = new JMenuItem(JMeterUtils.getResString((String)ACTION_SHUTDOWN), 89);
        this.run_shut.setAccelerator(KeyStrokes.ACTION_SHUTDOWN);
        this.run_shut.setEnabled(false);
        this.run_shut.addActionListener(ReportActionRouter.getInstance());
        this.run_shut.setActionCommand(ACTION_SHUTDOWN);
        this.run_clear = new JMenuItem(JMeterUtils.getResString((String)"clear"), 67);
        this.run_clear.addActionListener(ReportActionRouter.getInstance());
        this.run_clear.setActionCommand("action.clear");
        this.run_clearAll = new JMenuItem(JMeterUtils.getResString((String)"clear_all"), 97);
        this.run_clearAll.addActionListener(ReportActionRouter.getInstance());
        this.run_clearAll.setActionCommand("action.clear_all");
        this.run_clearAll.setAccelerator(KeyStrokes.CLEAR_ALL);
        this.runMenu.add(this.run_start);
        if (this.remote_start != null) {
            this.runMenu.add(this.remote_start);
        }
        this.remote_start_all = new JMenuItem(JMeterUtils.getResString((String)"remote_start_all"), 90);
        this.remote_start_all.setName("remote_start_all");
        this.remote_start_all.setAccelerator(KeyStrokes.REMOTE_START_ALL);
        this.remote_start_all.addActionListener(ReportActionRouter.getInstance());
        this.remote_start_all.setActionCommand("remote_start_all");
        this.runMenu.add(this.remote_start_all);
        this.runMenu.add(this.run_stop);
        this.runMenu.add(this.run_shut);
        if (this.remote_stop != null) {
            this.runMenu.add(this.remote_stop);
        }
        this.remote_stop_all = new JMenuItem(JMeterUtils.getResString((String)"remote_stop_all"), 88);
        this.remote_stop_all.setAccelerator(KeyStrokes.REMOTE_STOP_ALL);
        this.remote_stop_all.addActionListener(ReportActionRouter.getInstance());
        this.remote_stop_all.setActionCommand("remote_stop_all");
        this.runMenu.add(this.remote_stop_all);
        if (this.remote_exit != null) {
            this.runMenu.add(this.remote_exit);
        }
        this.remote_exit_all = new JMenuItem(JMeterUtils.getResString((String)"remote_exit_all"));
        this.remote_exit_all.addActionListener(ReportActionRouter.getInstance());
        this.remote_exit_all.setActionCommand("remote_exit_all");
        this.runMenu.add(this.remote_exit_all);
        this.runMenu.addSeparator();
        this.runMenu.add(this.run_clear);
        this.runMenu.add(this.run_clearAll);
    }

    private void makeEditMenu() {
        this.editMenu = new JMenu(JMeterUtils.getResString((String)"edit"));
        this.editMenu.setEnabled(false);
    }

    private void makeFileMenu() {
        this.fileMenu = new JMenu(JMeterUtils.getResString((String)"file"));
        this.fileMenu.setMnemonic('F');
        JMenuItem file_save = new JMenuItem(JMeterUtils.getResString((String)"save"), 83);
        file_save.setAccelerator(KeyStrokes.SAVE);
        file_save.setActionCommand("save");
        file_save.addActionListener(ReportActionRouter.getInstance());
        file_save.setEnabled(true);
        this.file_save_as = new JMenuItem(JMeterUtils.getResString((String)"save_all_as"), 65);
        this.file_save_as.setAccelerator(KeyStrokes.SAVE_ALL_AS);
        this.file_save_as.setActionCommand("save_all_as");
        this.file_save_as.addActionListener(ReportActionRouter.getInstance());
        this.file_save_as.setEnabled(true);
        this.file_load = new JMenuItem(JMeterUtils.getResString((String)"menu_open"), 79);
        this.file_load.setAccelerator(KeyStrokes.OPEN);
        this.file_load.addActionListener(ReportActionRouter.getInstance());
        this.file_load.setEnabled(false);
        this.file_load.setActionCommand("open");
        this.file_close = new JMenuItem(JMeterUtils.getResString((String)"menu_close"), 67);
        this.file_close.setAccelerator(KeyStrokes.CLOSE);
        this.file_close.setActionCommand("close");
        this.file_close.addActionListener(ReportActionRouter.getInstance());
        this.file_exit = new JMenuItem(JMeterUtils.getResString((String)"exit"), 88);
        this.file_exit.setAccelerator(KeyStrokes.EXIT);
        this.file_exit.setActionCommand("exit");
        this.file_exit.addActionListener(ReportActionRouter.getInstance());
        this.file_merge = new JMenuItem(JMeterUtils.getResString((String)"menu_merge"), 77);
        this.file_merge.addActionListener(ReportActionRouter.getInstance());
        this.file_merge.setEnabled(false);
        this.file_merge.setActionCommand("merge");
        this.fileMenu.add(this.file_close);
        this.fileMenu.add(this.file_load);
        this.fileMenu.add(this.file_merge);
        this.fileMenu.add(file_save);
        this.fileMenu.add(this.file_save_as);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.file_exit);
    }

    public void setRunning(boolean running, String host) {
        log.info("setRunning(" + running + "," + host + ")");
        Iterator<JMenuItem> iter = this.remote_engine_start.iterator();
        Iterator<JMenuItem> iter2 = this.remote_engine_stop.iterator();
        Iterator<JMenuItem> iter3 = this.remote_engine_exit.iterator();
        while (iter.hasNext() && iter2.hasNext() && iter3.hasNext()) {
            JMenuItem start = iter.next();
            JMenuItem stop = iter2.next();
            JMenuItem exit = iter3.next();
            if (start.getText().equals(host)) {
                log.info("Found start host: " + start.getText());
                start.setEnabled(!running);
            }
            if (stop.getText().equals(host)) {
                log.info("Found stop  host: " + stop.getText());
                stop.setEnabled(running);
            }
            if (!exit.getText().equals(host)) continue;
            log.info("Found exit  host: " + exit.getText());
            exit.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.run_start.setEnabled(!enable);
        this.run_stop.setEnabled(enable);
        this.run_shut.setEnabled(enable);
    }

    private void getRemoteItems() {
        if (this.remoteHosts.length > 0) {
            this.remote_start = new JMenu(JMeterUtils.getResString((String)"remote_start"));
            this.remote_stop = new JMenu(JMeterUtils.getResString((String)"remote_stop"));
            this.remote_exit = new JMenu(JMeterUtils.getResString((String)"remote_exit"));
            for (int i = 0; i < this.remoteHosts.length; ++i) {
                this.remoteHosts[i] = this.remoteHosts[i].trim();
                JMenuItem item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_start");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ReportActionRouter.getInstance());
                this.remote_engine_start.add(item);
                this.remote_start.add(item);
                item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_stop");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ReportActionRouter.getInstance());
                item.setEnabled(false);
                this.remote_engine_stop.add(item);
                this.remote_stop.add(item);
                item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_exit");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ReportActionRouter.getInstance());
                item.setEnabled(false);
                this.remote_engine_exit.add(item);
                this.remote_exit.add(item);
            }
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.updateMenuElement(this.fileMenu);
        this.updateMenuElement(this.editMenu);
        this.updateMenuElement(this.runMenu);
        this.updateMenuElement(this.optionsMenu);
        this.updateMenuElement(this.helpMenu);
    }

    private void updateMenuElement(MenuElement menu) {
        Component component = menu.getComponent();
        if (component.getName() != null) {
            ((JMenuItem)component).setText(JMeterUtils.getResString((String)component.getName()));
        }
        MenuElement[] subelements = menu.getSubElements();
        for (int i = 0; i < subelements.length; ++i) {
            this.updateMenuElement(subelements[i]);
        }
    }
}

