/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.util.ReportMenuBar;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.tree.ReportCellRenderer;
import org.apache.jmeter.report.gui.tree.ReportTreeListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReportMainFrame
extends JFrame {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String DEFAULT_TITLE = "Apache JMeter (" + JMeterUtils.getJMeterVersion() + ")";
    protected ReportMenuBar menuBar;
    protected JScrollPane mainPanel;
    protected JScrollPane treePanel;
    protected JTree tree;
    private final ImageIcon stoppedIcon = JMeterUtils.getImage((String)"thread.disabled.gif");
    private int previousDragXLocation = 0;
    private int previousDragYLocation = 0;
    private JButton runningIndicator;
    private JDialog stoppingMessage;

    @Deprecated
    public ReportMainFrame() {
        log.warn("Constructor only intended for use in testing");
    }

    public ReportMainFrame(TreeModel treeModel, ReportTreeListener treeListener) {
        this.runningIndicator = new JButton(this.stoppedIcon);
        this.runningIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.runningIndicator.setBorder(BorderFactory.createEmptyBorder());
        this.tree = this.makeTree(treeModel, treeListener);
        ReportGuiPackage.getInstance().setMainFrame(this);
        this.init();
        this.setDefaultCloseOperation(0);
    }

    public void setFileLoadEnabled(boolean enabled) {
        this.menuBar.setFileLoadEnabled(enabled);
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.menuBar.setFileSaveEnabled(enabled);
    }

    public void setEditMenu(JPopupMenu menu) {
        this.menuBar.setEditMenu(menu);
    }

    public void setEditEnabled(boolean enabled) {
        this.menuBar.setEditEnabled(enabled);
    }

    public void setEditAddMenu(JMenu menu) {
        this.menuBar.setEditAddMenu(menu);
    }

    public void setEditAddEnabled(boolean enabled) {
        this.menuBar.setEditAddEnabled(enabled);
    }

    public void setEditRemoveEnabled(boolean enabled) {
        this.menuBar.setEditRemoveEnabled(enabled);
    }

    public void closeMenu() {
        MenuElement[] menuElement;
        if (this.menuBar.isSelected() && (menuElement = this.menuBar.getSubElements()) != null) {
            for (int i = 0; i < menuElement.length; ++i) {
                JMenu menu = (JMenu)menuElement[i];
                if (!menu.isSelected()) continue;
                menu.setPopupMenuVisible(false);
                menu.setSelected(false);
                break;
            }
        }
    }

    public void showStoppingMessage(String host) {
        this.stoppingMessage = new JDialog(this, JMeterUtils.getResString((String)"stopping_test_title"), true);
        JLabel stopLabel = new JLabel(JMeterUtils.getResString((String)"stopping_test") + ": " + host);
        stopLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.stoppingMessage.getContentPane().add(stopLabel);
        this.stoppingMessage.pack();
        ComponentUtil.centerComponentInComponent((Component)this, (Component)this.stoppingMessage);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ReportMainFrame.this.stoppingMessage != null) {
                    ReportMainFrame.this.stoppingMessage.setVisible(true);
                }
            }
        });
    }

    public void setMainPanel(JComponent comp) {
        this.mainPanel.setViewportView(comp);
    }

    public JTree getTree() {
        return this.tree;
    }

    private void init() {
        this.menuBar = new ReportMenuBar();
        this.setJMenuBar(this.menuBar);
        JPanel all = new JPanel(new BorderLayout());
        all.add(this.createToolBar(), "North");
        JSplitPane treeAndMain = new JSplitPane(1);
        this.treePanel = this.createTreePanel();
        treeAndMain.setLeftComponent(this.treePanel);
        this.mainPanel = this.createMainPanel();
        treeAndMain.setRightComponent(this.mainPanel);
        treeAndMain.setResizeWeight(0.2);
        treeAndMain.setContinuousLayout(true);
        all.add((Component)treeAndMain, "Center");
        this.getContentPane().add(all);
        this.tree.setSelectionRow(1);
        this.addWindowListener(new WindowHappenings());
        this.setTitle(DEFAULT_TITLE);
        this.setIconImage(JMeterUtils.getImage((String)"icon-apache.png").getImage());
    }

    public void setExtendedFrameTitle(String fname) {
        if (fname == null) {
            this.setTitle(DEFAULT_TITLE);
            return;
        }
        String temp = fname.replace('\\', '/');
        String simpleName = temp.substring(temp.lastIndexOf(47) + 1);
        this.setTitle(simpleName + " (" + fname + ") - " + DEFAULT_TITLE);
    }

    protected Component createToolBar() {
        Box toolPanel = new Box(0);
        toolPanel.add(Box.createRigidArea(new Dimension(10, 15)));
        toolPanel.add(Box.createGlue());
        toolPanel.add(this.runningIndicator);
        return toolPanel;
    }

    protected JScrollPane createTreePanel() {
        JScrollPane treeP = new JScrollPane(this.tree);
        treeP.setMinimumSize(new Dimension(100, 0));
        return treeP;
    }

    protected JScrollPane createMainPanel() {
        return new JScrollPane();
    }

    private JTree makeTree(TreeModel treeModel, ReportTreeListener treeListener) {
        JTree treevar = new JTree(treeModel);
        treevar.setCellRenderer(this.getCellRenderer());
        treevar.setRootVisible(false);
        treevar.setShowsRootHandles(true);
        treeListener.setJTree(treevar);
        treevar.addTreeSelectionListener(treeListener);
        treevar.addMouseListener(treeListener);
        treevar.addMouseMotionListener(treeListener);
        treevar.addKeyListener(treeListener);
        return treevar;
    }

    protected TreeCellRenderer getCellRenderer() {
        ReportCellRenderer rend = new ReportCellRenderer();
        rend.setFont(new Font("Dialog", 0, 11));
        return rend;
    }

    public void drawDraggedComponent(Component dragIcon, int x, int y) {
        Dimension size = dragIcon.getPreferredSize();
        this.treePanel.paintImmediately(this.previousDragXLocation, this.previousDragYLocation, size.width, size.height);
        this.getLayeredPane().setLayer(dragIcon, 400);
        SwingUtilities.paintComponent(this.treePanel.getGraphics(), dragIcon, this.treePanel, x, y, size.width, size.height);
        this.previousDragXLocation = x;
        this.previousDragYLocation = y;
    }

    protected static class WindowHappenings
    extends WindowAdapter {
        protected WindowHappenings() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            ReportActionRouter.getInstance().actionPerformed(new ActionEvent(this, event.getID(), "exit"));
        }
    }
}

