/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.ReportMainFrame;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.report.engine.ValueReplacer;
import org.apache.jmeter.report.gui.tree.ReportTreeListener;
import org.apache.jmeter.report.gui.tree.ReportTreeModel;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.ReportPlan;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class ReportGuiPackage
implements LocaleChangeListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Object LOCK = new Object();
    private static volatile ReportGuiPackage guiPack;
    private boolean dirty = false;
    private Map<TestElement, JMeterGUIComponent> nodesToGui = new HashMap<TestElement, JMeterGUIComponent>();
    private Map<Class<?>, JMeterGUIComponent> guis = new HashMap();
    private Map<Class<?>, JMeterGUIComponent> testBeanGUIs = new HashMap();
    private ReportTreeNode currentNode = null;
    private boolean currentNodeUpdated = false;
    private ReportTreeModel treeModel;
    private ReportTreeListener treeListener;
    private ReportMainFrame mainFrame;
    private String reportPlanFile;

    private ReportGuiPackage() {
        JMeterUtils.addLocaleChangeListener((LocaleChangeListener)this);
    }

    public static ReportGuiPackage getInstance() {
        if (guiPack == null) {
            log.error("ReportGuiPackage is null");
        }
        return guiPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportGuiPackage getInstance(ReportTreeListener listener, ReportTreeModel treeModel) {
        if (guiPack == null) {
            Object object = LOCK;
            synchronized (object) {
                if (guiPack == null) {
                    guiPack = new ReportGuiPackage();
                    guiPack.setTreeListener(listener);
                    guiPack.setTreeModel(treeModel);
                }
            }
        }
        return guiPack;
    }

    public JMeterGUIComponent getGui(TestElement node) {
        String testClassName = node.getPropertyAsString("TestElement.test_class");
        String guiClassName = node.getPropertyAsString("TestElement.gui_class");
        try {
            Class<?> testClass = testClassName.equals("") ? node.getClass() : Class.forName(testClassName);
            Class<?> guiClass = null;
            if (!guiClassName.equals("")) {
                guiClass = Class.forName(guiClassName);
            }
            return this.getGui(node, guiClass, testClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not get GUI for " + node, (Throwable)e);
            return null;
        }
    }

    public JMeterGUIComponent getGui(TestElement node, Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.nodesToGui.get(node);
            if (comp == null) {
                comp = this.getGuiFromCache(guiClass, testClass);
                this.nodesToGui.put(node, comp);
            }
            log.debug("Gui retrieved = " + comp);
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public void removeNode(TestElement node) {
        this.nodesToGui.remove(node);
    }

    public JMeterGUIComponent getCurrentGui() {
        try {
            this.updateCurrentNode();
            TestElement curNode = this.treeListener.getCurrentNode().getTestElement();
            JMeterGUIComponent comp = this.getGui(curNode);
            comp.clearGui();
            log.debug("Updating gui to new node");
            comp.configure(curNode);
            this.currentNodeUpdated = false;
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public ReportTreeNode getNodeOf(TestElement userObject) {
        return this.treeModel.getNodeOf(userObject);
    }

    public TestElement createTestElement(Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.getGuiFromCache(guiClass, testClass);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public TestElement createTestElement(String objClass) {
        try {
            Class<?> c = Class.forName(objClass);
            JMeterGUIComponent comp = TestBean.class.isAssignableFrom(c) ? this.getGuiFromCache(TestBeanGUI.class, c) : this.getGuiFromCache(c, null);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (NoClassDefFoundError e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        catch (ClassNotFoundException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        catch (InstantiationException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    private JMeterGUIComponent getGuiFromCache(Class<?> guiClass, Class<?> testClass) throws InstantiationException, IllegalAccessException {
        JMeterGUIComponent comp;
        if (guiClass == TestBeanGUI.class) {
            comp = this.testBeanGUIs.get(testClass);
            if (comp == null) {
                comp = new TestBeanGUI(testClass);
                this.testBeanGUIs.put(testClass, comp);
            }
        } else {
            comp = this.guis.get(guiClass);
            if (comp == null && !((comp = (JMeterGUIComponent)guiClass.newInstance()) instanceof UnsharedComponent)) {
                this.guis.put(guiClass, comp);
            }
        }
        return comp;
    }

    public void updateCurrentGui() {
        this.updateCurrentNode();
        this.currentNode = this.treeListener.getCurrentNode();
        TestElement element = this.currentNode.getTestElement();
        JMeterGUIComponent comp = this.getGui(element);
        comp.configure(element);
        this.currentNodeUpdated = false;
    }

    public void updateCurrentNode() {
        try {
            if (this.currentNode != null && !this.currentNodeUpdated) {
                log.debug("Updating current node " + this.currentNode.getName());
                JMeterGUIComponent comp = this.getGui(this.currentNode.getTestElement());
                TestElement el = this.currentNode.getTestElement();
                comp.modifyTestElement(el);
            }
            if (this.currentNode != this.treeListener.getCurrentNode()) {
                this.currentNodeUpdated = true;
            }
            this.currentNode = this.treeListener.getCurrentNode();
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
        }
    }

    public ReportTreeNode getCurrentNode() {
        return this.treeListener.getCurrentNode();
    }

    public TestElement getCurrentElement() {
        return this.getCurrentNode().getTestElement();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public HashTree addSubTree(HashTree subTree) throws IllegalUserActionException {
        return this.treeModel.addSubTree(subTree, this.treeListener.getCurrentNode());
    }

    public HashTree getCurrentSubTree() {
        return this.treeModel.getCurrentSubTree(this.treeListener.getCurrentNode());
    }

    public ReportTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(ReportTreeModel newTreeModel) {
        this.treeModel = newTreeModel;
    }

    public ValueReplacer getReplacer() {
        return new ValueReplacer((ReportPlan)((ReportTreeNode)this.getTreeModel().getReportPlan().getArray()[0]).getTestElement());
    }

    public void setMainFrame(ReportMainFrame newMainFrame) {
        this.mainFrame = newMainFrame;
    }

    public ReportMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setTreeListener(ReportTreeListener newTreeListener) {
        this.treeListener = newTreeListener;
    }

    public ReportTreeListener getTreeListener() {
        return this.treeListener;
    }

    public void displayPopUp(MouseEvent e, JPopupMenu popup) {
        this.displayPopUp((Component)e.getSource(), e, popup);
    }

    public void displayPopUp(Component invoker, MouseEvent e, JPopupMenu popup) {
        if (popup != null) {
            log.debug("Showing pop up for " + invoker + " at x,y = " + e.getX() + "," + e.getY());
            popup.pack();
            popup.show(invoker, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocusInWindow();
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.updateCurrentNode();
        this.guis = new HashMap();
        this.nodesToGui = new HashMap<TestElement, JMeterGUIComponent>();
        this.testBeanGUIs = new HashMap();
        Introspector.flushCaches();
        ReportMainFrame mf = this.getMainFrame();
        if (mf == null) {
            log.warn("Mainframe is null");
        } else {
            mf.setMainPanel((JComponent)this.getCurrentGui());
            mf.setEditMenu(this.getTreeListener().getCurrentNode().createPopupMenu());
        }
    }

    public void setReportPlanFile(String f) {
        this.reportPlanFile = f;
        ReportGuiPackage.getInstance().getMainFrame().setExtendedFrameTitle(this.reportPlanFile);
        try {
            FileServer.getFileServer().setBasedir(this.reportPlanFile);
        }
        catch (IllegalStateException e1) {
            log.error("Failure setting file server's base dir", (Throwable)e1);
        }
    }

    public String getReportPlanFile() {
        return this.reportPlanFile;
    }
}

