/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.net.DatagramOutputTarget;

public class DatagramTargetFactory
extends AbstractTargetFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    public LogTarget createTarget(Configuration conf) throws ConfigurationException {
        InetAddress address;
        Configuration configChild = conf.getChild("address", false);
        if (null == configChild) {
            throw new ConfigurationException("target address not specified in the config");
        }
        try {
            address = InetAddress.getByName(configChild.getAttribute("hostname"));
        }
        catch (UnknownHostException uhex) {
            throw new ConfigurationException("Host specified in datagram target adress is unknown!", (Throwable)uhex);
        }
        int port = configChild.getAttributeAsInteger("port");
        Formatter formatter = this.getFormatter(conf.getChild("format", false));
        try {
            return new DatagramOutputTarget(address, port, formatter);
        }
        catch (IOException ioex) {
            throw new ConfigurationException("Failed to create target!", (Throwable)ioex);
        }
    }

    protected Formatter getFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        return new PatternFormatter(format);
    }

    static {
        FORMAT = FORMAT;
    }
}

