/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import java.io.Serializable;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.timers.Timer;

public class SyncTimer
extends AbstractTestElement
implements Timer,
Serializable,
TestBean,
TestStateListener,
ThreadListener {
    private static final long serialVersionUID = 2L;
    private transient BarrierWrapper barrier;
    private int groupSize;

    private Object readResolve() {
        this.createBarrier();
        return this;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(int numThreads) {
        this.groupSize = numThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delay() {
        if (this.getGroupSize() >= 0) {
            int arrival = 0;
            try {
                arrival = this.barrier.await();
            }
            catch (InterruptedException e) {
                long l = 0L;
                return l;
            }
            catch (BrokenBarrierException e) {
                long l = 0L;
                return l;
            }
            finally {
                if (arrival == 0) {
                    this.barrier.reset();
                }
            }
        }
        return 0L;
    }

    public Object clone() {
        SyncTimer newTimer = (SyncTimer)super.clone();
        newTimer.barrier = this.barrier;
        return newTimer;
    }

    public void testEnded() {
        this.testEnded(null);
    }

    public void testEnded(String host) {
        this.createBarrier();
    }

    public void testStarted() {
        this.testStarted(null);
    }

    public void testStarted(String host) {
        this.createBarrier();
    }

    private void createBarrier() {
        this.barrier = this.getGroupSize() == 0 ? new BarrierWrapper() : new BarrierWrapper(this.getGroupSize());
    }

    public void threadStarted() {
        if (this.getGroupSize() == 0) {
            int numThreadsInGroup = JMeterContextService.getContext().getThreadGroup().getNumThreads();
            this.barrier.setup(numThreadsInGroup);
        }
    }

    public void threadFinished() {
    }

    private static final class BarrierWrapper
    implements Cloneable {
        private CyclicBarrier barrier;

        public BarrierWrapper() {
            this.barrier = null;
        }

        public BarrierWrapper(int parties) {
            this.barrier = new CyclicBarrier(parties);
        }

        public synchronized void setup(int parties) {
            if (this.barrier == null) {
                this.barrier = new CyclicBarrier(parties);
            }
        }

        public int await() throws InterruptedException, BrokenBarrierException {
            return this.barrier.await();
        }

        public void reset() {
            this.barrier.reset();
        }

        protected Object clone() {
            BarrierWrapper barrierWrapper = null;
            try {
                barrierWrapper = (BarrierWrapper)super.clone();
                barrierWrapper.barrier = this.barrier;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return barrierWrapper;
        }
    }
}

