/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.jmeter.protocol.http.util.LoopbackHTTPSocket;

public class LoopbackHttpClientSocketFactory
implements ProtocolSocketFactory {
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return new LoopbackHTTPSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new LoopbackHTTPSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return new LoopbackHTTPSocket(host, port, localAddress, localPort);
        }
        return new LoopbackHTTPSocket(host, port, localAddress, localPort, timeout);
    }

    public static void setup() {
        String LOOPBACK = "loopback";
        Protocol.registerProtocol((String)"loopback", (Protocol)new Protocol("loopback", (ProtocolSocketFactory)new LoopbackHttpClientSocketFactory(), 1));
        URLStreamHandlerFactory ushf = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equalsIgnoreCase("loopback")) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return null;
                        }
                    };
                }
                return null;
            }
        };
        URL.setURLStreamHandlerFactory(ushf);
    }
}

