/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.SAXException;

class JTidyHTMLParser
extends HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();

    protected JTidyHTMLParser() {
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(byte[] html, URL baseUrl, URLCollection urls, String encoding) throws HTMLParseException {
        Document dom = null;
        try {
            dom = (Document)JTidyHTMLParser.getDOM(html, encoding);
        }
        catch (SAXException se) {
            throw new HTMLParseException(se);
        }
        this.scanNodes(dom, urls, baseUrl);
        return urls.iterator();
    }

    private URL scanNodes(Node node, URLCollection urls, URL baseUrl) throws HTMLParseException {
        if (node == null) {
            return baseUrl;
        }
        String name = node.getNodeName();
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.scanNodes(((Document)node).getDocumentElement(), urls, baseUrl);
                break;
            }
            case 1: {
                NodeList children;
                NamedNodeMap attrs = node.getAttributes();
                if (name.equalsIgnoreCase("base")) {
                    String tmp = this.getValue(attrs, "href");
                    if (tmp == null) break;
                    try {
                        baseUrl = ConversionUtils.makeRelativeURL(baseUrl, tmp);
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new HTMLParseException(e);
                    }
                }
                if (name.equalsIgnoreCase("img") || name.equalsIgnoreCase("embed")) {
                    urls.addURL(this.getValue(attrs, "src"), baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("applet")) {
                    urls.addURL(this.getValue(attrs, "code"), baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("object")) {
                    String data = this.getValue(attrs, "codebase");
                    if (!StringUtils.isEmpty((CharSequence)data)) {
                        urls.addURL(data, baseUrl);
                    }
                    if (StringUtils.isEmpty((CharSequence)(data = this.getValue(attrs, "data")))) break;
                    urls.addURL(data, baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("input")) {
                    String src = this.getValue(attrs, "src");
                    String typ = this.getValue(attrs, "type");
                    if (src == null || !typ.equalsIgnoreCase("image")) break;
                    urls.addURL(src, baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("link") && this.getValue(attrs, "rel").equalsIgnoreCase("stylesheet")) {
                    urls.addURL(this.getValue(attrs, "href"), baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("script")) {
                    urls.addURL(this.getValue(attrs, "src"), baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("frame")) {
                    urls.addURL(this.getValue(attrs, "src"), baseUrl);
                    break;
                }
                if (name.equalsIgnoreCase("iframe")) {
                    urls.addURL(this.getValue(attrs, "src"), baseUrl);
                    break;
                }
                String back = this.getValue(attrs, "background");
                if (back != null) {
                    urls.addURL(back, baseUrl);
                }
                if (name.equalsIgnoreCase("bgsound")) {
                    urls.addURL(this.getValue(attrs, "src"), baseUrl);
                    break;
                }
                String style = this.getValue(attrs, "style");
                if (style != null) {
                    HtmlParsingUtils.extractStyleURLs(baseUrl, urls, style);
                }
                if ((children = node.getChildNodes()) == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    baseUrl = this.scanNodes(children.item(i), urls, baseUrl);
                }
                break;
            }
        }
        return baseUrl;
    }

    private String getValue(NamedNodeMap attrs, String attname) {
        String v = null;
        Node n = attrs.getNamedItem(attname);
        if (n != null) {
            v = n.getNodeValue();
        }
        return v;
    }

    private static Tidy getTidyParser(String encoding) {
        log.debug("Start : getParser");
        Tidy tidy = new Tidy();
        tidy.setInputEncoding(encoding);
        tidy.setOutputEncoding("UTF8");
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        if (log.isDebugEnabled()) {
            log.debug("getParser : tidy parser created - " + tidy);
        }
        log.debug("End   : getParser");
        return tidy;
    }

    private static Node getDOM(byte[] text, String encoding) throws SAXException {
        log.debug("Start : getDOM");
        Document node = JTidyHTMLParser.getTidyParser(encoding).parseDOM((InputStream)new ByteArrayInputStream(text), null);
        if (log.isDebugEnabled()) {
            log.debug("node : " + node);
        }
        log.debug("End   : getDOM");
        return node;
    }
}

