/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.net.URL;
import java.util.Date;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieHandler;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HC3CookieHandler
implements CookieHandler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final transient CookieSpec cookieSpec;

    public HC3CookieHandler(String policy) {
        this.cookieSpec = CookiePolicy.getCookieSpec((String)policy);
    }

    private org.apache.commons.httpclient.Cookie makeCookie(Cookie jmc) {
        long exp = jmc.getExpiresMillis();
        org.apache.commons.httpclient.Cookie ret = new org.apache.commons.httpclient.Cookie(jmc.getDomain(), jmc.getName(), jmc.getValue(), jmc.getPath(), exp > 0L ? new Date(exp) : null, jmc.getSecure());
        ret.setPathAttributeSpecified(jmc.isPathSpecified());
        ret.setDomainAttributeSpecified(jmc.isDomainSpecified());
        ret.setVersion(jmc.getVersion());
        return ret;
    }

    org.apache.commons.httpclient.Cookie[] getCookiesForUrl(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        org.apache.commons.httpclient.Cookie[] cookies = new org.apache.commons.httpclient.Cookie[cookiesCP.size()];
        int i = 0;
        PropertyIterator iter = cookiesCP.iterator();
        while (iter.hasNext()) {
            Cookie jmcookie = (Cookie)iter.next().getObjectValue();
            if (allowVariableCookie) {
                jmcookie.setRunningVersion(true);
            }
            cookies[i++] = this.makeCookie(jmcookie);
            if (!allowVariableCookie) continue;
            jmcookie.setRunningVersion(false);
        }
        String host = url.getHost();
        String protocol = url.getProtocol();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean secure = HTTPSamplerBase.isSecure(protocol);
        return this.cookieSpec.match(host, port, path, secure, cookies);
    }

    @Override
    public String getCookieHeaderForURL(CollectionProperty cookiesCP, URL url, boolean allowVariableCookie) {
        org.apache.commons.httpclient.Cookie[] c = this.getCookiesForUrl(cookiesCP, url, allowVariableCookie);
        int count = c.length;
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Found " + count + " cookies for " + url.toExternalForm());
        }
        if (count <= 0) {
            return null;
        }
        String hdr = this.cookieSpec.formatCookieHeader(c).getValue();
        if (debugEnabled) {
            log.debug("Cookie: " + hdr);
        }
        return hdr;
    }

    @Override
    public void addCookieFromHeader(CookieManager cookieManager, boolean checkCookies, String cookieHeader, URL url) {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug("Received Cookie: " + cookieHeader + " From: " + url.toExternalForm());
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = HTTPSamplerBase.getDefaultPort(protocol, url.getPort());
        String path = url.getPath();
        boolean isSecure = HTTPSamplerBase.isSecure(protocol);
        org.apache.commons.httpclient.Cookie[] cookies = null;
        try {
            cookies = this.cookieSpec.parse(host, port, path, isSecure, cookieHeader);
        }
        catch (MalformedCookieException e) {
            log.warn(cookieHeader + e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            log.warn(cookieHeader + e.getLocalizedMessage());
        }
        if (cookies == null) {
            return;
        }
        for (org.apache.commons.httpclient.Cookie cookie : cookies) {
            try {
                if (checkCookies) {
                    this.cookieSpec.validate(host, port, path, isSecure, cookie);
                }
                Date expiryDate = cookie.getExpiryDate();
                long exp = 0L;
                if (expiryDate != null) {
                    exp = expiryDate.getTime();
                }
                Cookie newCookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure(), exp / 1000L, cookie.isPathAttributeSpecified(), cookie.isDomainAttributeSpecified());
                if (exp == 0L || exp >= System.currentTimeMillis()) {
                    newCookie.setVersion(cookie.getVersion());
                    cookieManager.add(newCookie);
                    continue;
                }
                cookieManager.removeMatchingCookies(newCookie);
                if (!debugEnabled) continue;
                log.debug("Dropping expired Cookie: " + newCookie.toString());
            }
            catch (MalformedCookieException e) {
                log.warn("Not storing invalid cookie: <" + cookieHeader + "> for URL " + url + " (" + e.getLocalizedMessage() + ")");
            }
            catch (IllegalArgumentException e) {
                log.warn(cookieHeader + e.getLocalizedMessage());
            }
        }
    }
}

