#ifndef EFFORT_H
#define EFFORT_H

#define EFFORT_OBJ 0
#define EFFORT_LMF 1

#include <Windows.h>
//

typedef struct lmf_vec_s {
	FLOAT x, y, z;
} lmf_vec_t;

typedef struct lmf_face_s {
	INT vertexes[3]; INT normals[3];
} lmf_face_t;

typedef struct lmf_texture_s {
	char texname[64];
	INT16 w, h;
	BYTE* colordata;
} lmf_texture_t;

typedef struct lmf_file_s {
	INT numvertexes;
	lmf_vec_t* vertexes;
	INT numtextures;
	lmf_texture_t* textures;
	INT numnormals;
	lmf_vec_t* normals;
	INT numfaces;
	lmf_face_t* faces;
	BYTE* colors;
	BYTE type;
} lmf_file_t;


void M_LoadOBJ( char* filename );
void M_LoadLMF( char* filename );
void M_ConvertToLMF( char* output );

void R_BringAboutGL( HDC hdc );

void R_DrawModel( lmf_file_t* mdl );

#endif