#pragma warning( disable : 4996 ) // Allow non _s func's

// EVERYTHING DBL & DATACHUNKS RELATED

#ifndef DBLREADER_H
#define DBLREADER_H

#include <Windows.h>
#include <stdio.h>
#include <msclr\marshal.h>

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace msclr::interop;

extern INT* pDBLChunkHeaders;
extern INT iCurrentChunk;

#define FLAG_0E 64
#define FLAG_0B 64
#define FLAG_06 42
#define FLAG_00 10
#define DBL_CHUNK_NODBLHEADER -2

typedef struct dbl_header_t {
	char* dblId;
	INT iChunksNum; // The number is REAL
} dbl_header_s;

/*typedef struct dbl_texture_s {
	INT tex_type; INT w; INT h; const char* tex_name;
	INT tex_offset; INT pal_offset;
} dbl_texture_t;*/

typedef struct dbl_chunk_header_t {
	INT16 iDataChunkType;
	INT16 iFlag;
	INT iDataChunkSize;
	INT iDataFinalOffset;
	INT iDataChunkVer;
} dbl_chunk_header_s;

String^ MakeString( char* str );

// Read a chunk header if we're given an offset
dbl_chunk_header_s* ReadChunkHeader( FILE* pFile, INT iOffset, dbl_header_s* pDBLHeader );

// Read the DBL header and return the offset to the first data-chunk
INT ReadDBLHeader( FILE* pFile, dbl_header_s* pHeader );

// See if the DBL ID is valid or not
BOOL CheckDBLId( dbl_header_s* header );

// Load the DBL file into memory for further processing
BOOL ReadDBLFile( const char* file, System::Windows::Forms::RichTextBox^ logbox );

// Extract chunks from the loaded DBL file and put them into the output folder
BOOL ExtractChunks( const char* output, System::Windows::Forms::RichTextBox^ logbox );

// Compiles a DBL file out of the data chunk files taken from the input folder
// Output is the DBL file that will be created
// logbox is the pointer to the log textbox in the window
// pParams is the header
BOOL CreateDBL( const char* input, const char* output,
			   System::Windows::Forms::RichTextBox^ logbox, dbl_header_s* pParams );

// Self explanatory
dbl_chunk_header_s* LoadChunkFromFile( const char* chunk );

// Change chunk header to the given one
BOOL ChangeChunkHeader( const char* chunk, dbl_chunk_header_s* header, System::Windows::Forms::RichTextBox^ logbox );

// Calculate the chunk size & write into header
BOOL UpdateChunkSize( const char* chunk, System::Windows::Forms::RichTextBox^ logbox );

#endif